//
//  StaticData.swift
//  Do It
//
//  Created by Jim Dovey on 8/23/19.
//  Copyright © 2019 Jim Dovey. All rights reserved.
//

import Foundation
import SwiftUI

struct TodoData: Codable {
    var lists: [TodoItemList]
    var items: [TodoItem]
}

let defaultTodoData: TodoData = loadData(from: Bundle.main.url(forResource: "todo-items", withExtension: "json")!)

let defaultTodoItems: [TodoItem] = defaultTodoData.items
let defaultTodoLists: [TodoItemList] = defaultTodoData.lists

let listIconChoices: [[String]] = loadData(from: Bundle.main.url(forResource: "list-icons", withExtension: "json")!)

func loadData<T: Decodable>(from url: URL, as type: T.Type = T.self) -> T {
    do {
        let data = try Data(contentsOf: url, options: [.mappedIfSafe, .uncached])
        let decoder = JSONDecoder()
        decoder.dateDecodingStrategy = .iso8601
        return try decoder.decode(T.self, from: data)
    } catch {
        fatalError("Failed to load JSON data: \(error)")
    }
}
